import mlflow
import sklearn
import numpy as np
import pandas as pd
from mlflow.models import infer_signature
from sklearn.ensemble import RandomForestClassifier
from sklearn.model_selection import train_test_split
from sklearn.metrics import confusion_matrix, accuracy_score
from mlflow.utils.environment import _mlflow_conda_env


custom_packages = _mlflow_conda_env(
    additional_conda_deps=['scikit-learn','pip','pandas'],
    additional_pip_deps=['azureml-defaults','azureml-sdk'],
    additional_conda_channels=None,
)


def train_and_log(input_data: str, register_model: bool = False):
    model_name = "weather-classifier-dummy"
    data = pd.read_csv(input_data)
    y= data ['Weather Type']
    x= data.drop('Weather Type',axis=1)
    x=pd.get_dummies(x, dtype='int')

    from sklearn.model_selection import train_test_split
    x_train,x_test,y_train,y_test=train_test_split(x,y,test_size=0.2, random_state=0)

    
    classifier=RandomForestClassifier(n_estimators=500,criterion='entropy',random_state=0)
    model=classifier.fit(x_train,y_train)
    y_pred=model.predict(x_test)

    accuracy = accuracy_score(y_test, y_pred)
    print("Accuracy: %.2f%%" % (accuracy * 100.0))
    mlflow.log_metric("accuracy", accuracy)

    signature = infer_signature(x_test, y_test)
    mlflow.sklearn.log_model(model, "classifier_myenv", signature=signature,  conda_env=custom_packages)

        

